<?php

namespace Code_Snippets;

use  Freemius ;
use  Freemius_Exception ;
use function  fs_dynamic_init ;
/**
 * Handles interfacing with the Freemius SDK and API.
 *
 * @package Code_Snippets
 */
class Licensing
{
    /**
     * Freemius product ID.
     */
    const  PRODUCT_ID = 10565 ;
    /**
     * Freemius public key.
     */
    const  PUBLIC_KEY = 'pk_107ff34fc0b2a9700c150c1acf13a' ;
    /**
     * Freemius SDK instance.
     *
     * @var Freemius
     */
    public  $sdk ;
    /**
     * Class constructor.
     *
     * @throws Freemius_Exception Freemius fails to initialise.
     */
    public function __construct()
    {
        $plugin = code_snippets();
        $this->enable_multisite_support();
        $this->register_hooks();
    }
    
    /**
     * Create the necessary constant to enable multisite support within the Freemius SDK.
     *
     * @return void
     */
    private function enable_multisite_support()
    {
        $constant_name = sprintf( 'WP_FS__PRODUCT_%d_MULTISITE', self::PRODUCT_ID );
        if ( !defined( $constant_name ) ) {
            define( $constant_name, true );
        }
    }
    
    /**
     * Determine whether the current site has an active license.
     *
     * @return bool
     */
    public function is_licensed()
    {
        return true;
    }
    
    /**
     * Determine whether the current site has any license, including an expired license.
     *
     * @return bool
     */
    public function was_licensed()
    {
        return true;
    }
    
    /**
     * Register hooks with Freemius.
     *
     * @return void
     */
    public function register_hooks()
    {
        add_action( 'after_uninstall', [ $this, 'uninstall_hook' ] );
        add_filter(
            'is_submenu_visible',
            [ $this, 'is_submenu_visible' ],
            10,
            2
        );
        add_filter( 'plugin_icon', [ $this, 'plugin_icon' ] );
    }
    
    /**
     * Get the relative path to the plugin icon.
     *
     * @return string
     */
    public function plugin_icon()
    {
        return dirname( CODE_SNIPPETS_FILE ) . '/assets/icon.svg';
    }
    
    /**
     * Control whether a Freemius submenu is visible.
     *
     * @param bool   $is_visible Whether the submenu is visible.
     * @param string $submenu_id Submenu ID.
     *
     * @return bool
     */
    public function is_submenu_visible( $is_visible, $submenu_id )
    {
        return ( 'account' === $submenu_id ? $is_visible : false );
    }
    
    /**
     * Clean up data when the plugin is uninstalled.
     *
     * @return void
     */
    public function uninstall_hook()
    {
        require_once __DIR__ . '/uninstall.php';
        Uninstall\uninstall_plugin();
    }
    
    /**
     * Override default strings used by Freemius to better integrate it with the rest of the plugin.
     *
     * @return void
     */
    public function override_strings()
    {
		//
    }

}